var http = require('http');
var url = require('url');
var express = require('express');
var app = express();
var admin = require("firebase-admin");
var userPerPage = 14;   
var serverToken = process.env.token;

var serviceAccount = require("./ADMIN SDK.json");

admin.initializeApp({
  credential: admin.credential.cert(serviceAccount),
  databaseURL: "Firebase Database URL"
});

app.get('/setUserCredit/:token/:uid/:credit', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });

    var token = req.params.token;
    var uid = req.params.uid;
    var credit = req.params.credit;

    if (token == serverToken && uid != null && credit != null) {
                
        var db = admin.database();
        var ref = db.ref("users").child(uid);
         
        ref.update({"credit": credit}, function(error) {
            if (error) {
                res.end('{"status":"error"}');
         } else {
                res.end('{"status":"ok"}');
            }
        });
        
    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/getUsers/:token/:page', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });
    
    var token = req.params.token;
    var page = req.params.page;
    
    if (token == serverToken && page != null) {
        
        var db = admin.database();  
		const startIndex = (page - 1) * userPerPage + 1;     
		        const endIndex = page * userPerPage;
				
                var ref = db.ref("users").orderByChild("id");
        ref.once("value", function(data) {
            res.end(JSON.stringify(data));
        });
        
    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/setUserVip/:token/:uid/:vipid/:time', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });

    var token = req.params.token;
    var uid = req.params.uid;
    var vipid = req.params.vipid;
    var time = req.params.time;

    if (token == serverToken && uid != null && vipid != null && time != null) {
        var db = admin.database();
        var ref = db.ref("users").child(uid);
        
        if(vipid == "ovun"){
             ref.update({"ovun": time}, function(error) {
                if (error) {
                    res.end('{"status":"error"}');
             } else {
                    res.end('{"status":"ok"}');
                }
            });
        }else if(vipid == "htft"){
             ref.update({"htft": time}, function(error) {
                if (error) {
                    res.end('{"status":"error"}');
             } else {
                    res.end('{"status":"ok"}');
                }
            });
        }else if(vipid == "twoh"){
             ref.update({"twoh": time}, function(error) {
                if (error) {
                    res.end('{"status":"error"}');
             } else {
                    res.end('{"status":"ok"}');
                }
            });
        }else if(vipid == "plat"){
             ref.update({"plat": time}, function(error) {
                if (error) {
                    res.end('{"status":"error"}');
             } else {
                    res.end('{"status":"ok"}');
                }
            });
        }else{
            res.end('{"status":"invalid_vip_id"}');
        }

    } else {
        res.end('{"status":"null_request"}');
    }
});

app.get('/searchUser/:token/:email', async (req, res, next) => {
    res.writeHead(200, {
        'Content-Type': 'application/json; charset=utf-8',
        'Access-Control-Allow-Origin': '*'
    });
    
    var token = req.params.token;
    var email = req.params.email;
    
    if (token == serverToken && email != null) {
          admin
            .auth()
            .getUserByEmail(email)
            .then((userRecord) => {
               var db = admin.database();
               var ref = db.ref("users").child(userRecord["uid"]);
    
               ref.once("value", function(data) {
                   var userData = data.val();
                   res.write('{');
                   res.write('"uid":"' + userRecord["uid"] + '",');
                   res.write('"credit":' + userData.credit + ',');
                   res.write('"email":"' + userData.email + '",');
                   res.write('"htft":' + userData.htft + ',');
                   res.write('"id":' + userData.id + ',');
                   res.write('"name":"' + userData.name + '",');
                   res.write('"ovun":' + userData.ovun + ',');
                   res.write('"plat":' + userData.plat + ',');
                   res.write('"purchasedIDs":"' + userData.purchasedIDs + '",');
                   res.write('"surname":"' + userData.surname + '",');
                   res.write('"twoh":' + userData.twoh);
                   res.end("}");
               });
               
            })
            .catch((error) => {
               res.end('{"status":"not_found"}');
            });

    } else {
        res.end('{"status":"null_request"}');
    }
});

app.listen(8080);