<?php
require("include/conn.php");
ob_start();
session_start();
if(isset($_SESSION["s_username"],$_SESSION["s_pass"])){
    header("Location: index.php");
}else{ ?>

<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>RoidBett - Betting Panel Admin Login</title>
    <link href="vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">
    <link href="css/sb-admin-2.css" rel="stylesheet">
    <link rel="stylesheet" href="css/toastr.min.css"crossorigin="anonymous">
</head>

<body class="bg-gradient-danger">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xl-6 col-lg-12 col-md-9">
                <div class="card o-hidden border-0 shadow-lg my-5">
                    <div class="card-body p-0">
                        <div class="p-5">
                            <div class="text-center">
                                 <h1 class="h4 text-gray-900 mb-4">Welcome again!</h1>
                            </div>
                            <form class="user" id="loginForm" method="POST">
                                <div class="form-group">
                                     <input type="text" class="form-control form-control-user" id="InputUser" name="username" aria-describedby="emailHelp" placeholder="Username">
                                </div>
                                <div class="form-group">
                                    <input type="password" class="form-control form-control-user" id="InputPassword" name="password" placeholder="Password">
                                </div>
                                <button type="submit" class="btn btn-primary btn-user btn-block" id="loginBtn">
                                    Login
                                </button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="vendor/jquery/jquery.min.js"></script>
    <script src="vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="vendor/jquery-easing/jquery.easing.min.js"></script>
    <script src="js/sb-admin-2.min.js"></script>
    <script src="js/toastr.min.js" crossorigin="anonymous"></script>
    <script>
         $('#loginForm').submit(function(event) {
            $("#loginBtn").html('<div class="spinner-border spinner-border-sm" role="status"><span class="sr-only">Loading...</span></div>');
            $("#loginBtn").prop( "disabled", true );
            $.ajax({
                url: "include/login.php", 
                type: "POST",             
                data: $('#loginForm').serialize(),
                success: function(data) {
                    if(data == "wrong"){
                        toastr["error"]("Wrong username or password !", "ERROR")
                        $("#loginBtn").html('Login');
                        $("#loginBtn").prop( "disabled", false );
                    }else if(data == "restricted"){
                        toastr["info"]("Your account is not active. Contact the administrator.", "İnfo")
                        $("#loginBtn").html('Login');
                        $("#loginBtn").prop( "disabled", false );
                    }else if(data == "ok"){
                        $("#loginBtn").html('Login successful :)');
                        window.location.href = 'betting.php';
                    }
                },
                error: function(err){
                    console.log(err);
                    $("#loginBtn").html('Something went wrong !');
                }
            });
            event.preventDefault();

        });

        toastr.options = {
          "closeButton": true,
          "debug": false,
          "newestOnTop": false,
          "progressBar": true,
          "positionClass": "toast-top-right",
          "preventDuplicates": false,
          "onclick": null,
          "showDuration": "3000",
          "hideDuration": "1000",
          "timeOut": "3000",
          "extendedTimeOut": "1000",
          "showEasing": "swing",
          "hideEasing": "linear",
          "showMethod": "fadeIn",
          "hideMethod": "fadeOut"
        }

    </script>
</body>
</html>
<?php } ?>