$('#userSetForm').submit(function(event) {
	 event.preventDefault();
	 if($("#inputPassFirst").val() == $("#inputPassSec").val()){
        $.ajax({
            url: "./include/changeUserPass.php", 
            type: "POST",             
            data: $('#userSetForm').serialize(),
            beforeSend: function() {
         	   $("#userSaveBtn").html('<div class="spinner-border spinner-border-sm" role="status"><span class="sr-only">Loading...</span></div>');          
            },
            success: function(data) {
         	   if(data == "ok"){
         	      let timerInterval
         	      Swal.fire({
                    title: 'Change Password',
                    html: 'Your password has been successfully changed.',
                    timer: 2000,
                    timerProgressBar: true,
                    showCancelButton: false,
                    didOpen: () => {
                      Swal.showLoading();
                      $("#usettingsModal").modal('hide');
                      $("#userSaveBtn").html('Save');
                    },
                    willClose: () => {
                      clearInterval(timerInterval)
                    }
                  })
         	   }else if(data == "wrong_old_pass"){
         		   $("#userSaveBtn").html('Incorrect old password !');
         		   setInterval(function() {
                       $("#userSaveBtn").html('Save');
                   }, 3000);
         	   }
            },
            error: function(err){
                console.log(err);
                $("#userSaveBtn").html('Something went wrong !');
            }
        });
    }else{
       $("#userSaveBtn").html('Passwords do not match!');
       setInterval(function() {
                $("#userSaveBtn").html('Save');
       }, 3000);
    }
});

function saveUserLevel(selectID,ID){
  var newLevel = $("#" + selectID).val();
  var saveBtn = "#saveUserLevelBtn" + ID;
  $.ajax({
    url: "./include/updateUserLevel.php", 
    type: "POST",             
    data: {id:ID, nlevel:newLevel},
    beforeSend: function() {
      $(saveBtn).html('<div class="spinner-border spinner-border-sm" role="status"><span class="sr-only">Loading...</span></div>');          
    },
    success: function(data) {
      if(data=="ok"){
        $(saveBtn).html('It Saved !');
        setTimeout(function() {
             $(saveBtn).html('Save');
        }, 2000);
      }else if(data=="auth_error"){
        $(saveBtn).html('Insufficient authorization!');
        setTimeout(function() {
             $(saveBtn).html('Save');
        }, 2000);
      }
    },
    error: function(err){
       console.log(err);
       $(saveBtn).html('Something went wrong !');
     }
   });
}