package com.roid.bettingtips.pages

import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ProgressBar
import android.widget.RelativeLayout
import androidx.core.view.isVisible
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.google.firebase.auth.FirebaseAuth
import com.roid.bettingtips.ItemClickListener
import com.roid.bettingtips.R
import com.roid.bettingtips.adapters.RCAdapterWon
import com.roid.bettingtips.data.CatData
import okhttp3.*
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException
import java.util.*


class WonFragment : Fragment(), ItemClickListener {
    private lateinit var swipeRefresh: SwipeRefreshLayout
    private lateinit var rcview: RecyclerView
    private lateinit var loadingMore: ProgressBar
    private lateinit var loadingLy: RelativeLayout
    private var adapter: RecyclerView.Adapter<RCAdapterWon.ViewHolder>? = null
    private var layoutManager: RecyclerView.LayoutManager? = null
    private val client = OkHttpClient()
    private var serverUrl: String = "https://api.roidbetting.online/getWonData"
    private var macList: MutableList<CatData> = mutableListOf()
    private var macLang = "tr"
    private var utoken: String = "null"
    private var moreLoading = false
    private var fullyLoaded = false
    private var pageId = 1


    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val v = inflater.inflate(R.layout.fragment_won, container, false)

        swipeRefresh = v.findViewById(R.id.swiperefresh)
        loadingMore = v.findViewById(R.id.loadingMore)
        loadingLy = v.findViewById(R.id.loadingLayout)
        rcview = v.findViewById(R.id.RCviewWon)
        layoutManager = LinearLayoutManager(activity)
        rcview.layoutManager = layoutManager

        macLang = if(Locale.getDefault().language == "tr"){ "tr" }else{ "en" }

        rcview.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                if (dy > 0) {
                    val visibleItemCount = layoutManager?.childCount
                    val totalItemCount = layoutManager?.itemCount
                    val pastVisiblesItems = (rcview.layoutManager as LinearLayoutManager?)?.findFirstVisibleItemPosition()

                    if(!moreLoading && !fullyLoaded){
                        if ((visibleItemCount!! + pastVisiblesItems!!) >= totalItemCount!!) {
                            loadingMore.visibility = View.VISIBLE
                            pageId += 1
                            getData(pageId)
                            moreLoading = true
                        }
                    }
                }
            }
        })

        swipeRefresh.setOnRefreshListener {
            getData(1)
            fullyLoaded = false
        }

        FirebaseAuth.getInstance().currentUser?.getIdToken(true)?.addOnSuccessListener {
            it.token?.let { it1 -> utoken = it1 }
            getData(1)
        }

        return v
    }

    private fun getData(page: Int){
        if(page == 1 && !loadingLy.isVisible){
            loadingLy.visibility = View.VISIBLE
        }

        pageId = page

        val url = "$serverUrl/$utoken/$macLang/$page"

        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                activity?.runOnUiThread {
                    showErrorMsg()
                }
            }

            override fun onResponse(call: Call, response: Response) {
                activity?.runOnUiThread {
                    try {
                        val strResponse = response.body()!!.string()
                        val json = JSONObject(strResponse)

                        loadingLy.visibility = View.GONE

                        if(loadingMore.isVisible){
                            loadingMore.visibility = View.GONE
                        }

                        moreLoading = false

                        if (json.has("status")) {
                            val status = json.getString("status")
                            if(status == "ok"){
                                if(page == 1){
                                    macList.clear()
                                }

                                val data = json.getJSONObject("data")
                                for (i in 0 until data.length()) {
                                    val item = data.getJSONObject(i.toString())
                                    macList.add(CatData(item.getString("id").toInt(), item.getString("price").toInt(), item.getString("userBought").toInt(), item.getString("leagueName"), item.getString("teamOne"), item.getString("teamTwo"), item.getString("date"), item.getString("result").toInt(), item.getString("teamOneScore"), item.getString("teamTwoScore"), item.getString("info"), item.getString("ratio"),
                                        item.getString("mac_cat").toString()))
                                }
                                setData()
                            }else if(status == "null_data"){
                                fullyLoaded = true
                                swipeRefresh.isRefreshing = false
                            }
                        }
                    } catch (jpe: JSONException) {
                        showErrorMsg()
                        Log.d("testRun", jpe.toString())
                    } catch (ioe: IOException) {
                        showErrorMsg()
                        Log.d("testRun", ioe.toString())
                    }
                }
            }
        })
    }

    private fun setData(){
        if(macList.size > 0){
            adapter = activity?.let { RCAdapterWon(macList, it, this) }
            rcview.adapter = adapter
        }
        if(loadingLy.isVisible){
            loadingLy.visibility = View.GONE
        }
        swipeRefresh.isRefreshing = false
    }

    override fun onClick(id: Int, price: Int, result: Int){
        showResultMsg()
    }

    private fun showResultMsg(){
        val builder = activity?.let { androidx.appcompat.app.AlertDialog.Builder(it) }
        builder?.setTitle(getString(R.string.error))
        builder?.setMessage(getString(R.string.gameFinished))
            ?.setCancelable(true)
            ?.setPositiveButton(getString(R.string.ok)) { _, _ ->
            }
        val alert = builder?.create()
        alert?.show()
    }

    private fun showErrorMsg(){
        val builder = activity?.let { androidx.appcompat.app.AlertDialog.Builder(it) }
        builder?.setTitle(getString(R.string.error))
        builder?.setMessage(getString(R.string.errorGet))
            ?.setCancelable(false)
            ?.setPositiveButton(getString(R.string.retry)) { _, _ ->
                getData(1)
            }
        val alert = builder?.create()
        alert?.show()
    }

}