package com.roid.bettingtips.pages

import android.content.Intent
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.*
import androidx.core.view.isVisible
import com.google.firebase.auth.ktx.auth
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.ValueEventListener
import com.google.firebase.database.ktx.database
import com.google.firebase.ktx.Firebase
import com.roid.bettingtips.*
import okhttp3.Call
import okhttp3.OkHttpClient
import okhttp3.Response
import java.util.*
import org.json.JSONException
import org.json.JSONObject
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.roid.bettingtips.R
import com.roid.bettingtips.adapters.RCAdapterNews
import com.roid.bettingtips.data.NewsData
import okhttp3.*
import java.io.IOException


class VipFragment : Fragment(), ItemClickListener {
    private lateinit var swipeRefresh: SwipeRefreshLayout
    private lateinit var rcview: RecyclerView
    private lateinit var loadingMore: ProgressBar
    private lateinit var loadingLy: RelativeLayout
    private var adapter: RecyclerView.Adapter<RCAdapterNews.ViewHolder>? = null
    private var layoutManager: RecyclerView.LayoutManager? = null
    private var macLang = "tr"
    private var macList1: MutableList<NewsData> = mutableListOf()
    private var moreLoading = false
    private var fullyLoaded = false
    private var pageId = 1
    private val client = OkHttpClient()
    private var serverUrl: String = "https://api.roidbetting.online/getNewsData"
    private lateinit var database: DatabaseReference
    private var ovunEnabled = false
    private var htftEnabled = false
    private var oddsEnabled = false
    private var platEnabled = false

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val v =  inflater.inflate(R.layout.fragment_vip, container, false)

        val ovunBtn: Button = v.findViewById(R.id.ovunBtn)
        val htftBtn: Button = v.findViewById(R.id.htftBtn)
        val oddsBtn: Button = v.findViewById(R.id.oddsBtn)
        val platBtn: Button = v.findViewById(R.id.mvipBtn)
        database = Firebase.database.reference
        val user = Firebase.auth.currentUser

        loadingMore = v.findViewById(R.id.loadingMore)
        loadingLy = v.findViewById(R.id.loadingLayout)
        swipeRefresh = v.findViewById(R.id.swiperefresh)
        rcview = v.findViewById(R.id.RCviewNews)
        layoutManager = LinearLayoutManager(activity)
        rcview.layoutManager = layoutManager

        macLang = if(Locale.getDefault().language == "tr"){ "tr" }else{ "en" }

        rcview.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                if (dy > 0) {
                    val visibleItemCount = layoutManager?.childCount
                    val totalItemCount = layoutManager?.itemCount
                    val pastVisiblesItems = (rcview.layoutManager as LinearLayoutManager?)?.findFirstVisibleItemPosition()

                    if(!moreLoading && !fullyLoaded){
                        if ((visibleItemCount!! + pastVisiblesItems!!) >= totalItemCount!!) {
                            loadingMore.visibility = View.VISIBLE
                            pageId += 1
                            getNewsData(pageId)
                            moreLoading = true
                        }
                    }
                }
            }
        })

        if (user != null) {
            val ordersRef = database.child("users").child(user.uid)
            val valueEventListener = object : ValueEventListener {
                override fun onDataChange(dataSnapshot: DataSnapshot) {
                    val ovun =  dataSnapshot.child("ovun").value.toString().toLong()
                    val htft = dataSnapshot.child("htft").value.toString().toLong()
                    val odds = dataSnapshot.child("twoh").value.toString().toLong()
                    val plat = dataSnapshot.child("plat").value.toString().toLong()

                    ovunEnabled = Calendar.getInstance() < getDate(ovun)
                    htftEnabled = Calendar.getInstance() < getDate(htft)
                    oddsEnabled = Calendar.getInstance() < getDate(odds)
                    platEnabled = Calendar.getInstance() < getDate(plat)
                }

                override fun onCancelled(databaseError: DatabaseError) {
                    Log.d("Data", databaseError.message)
                }
            }
            ordersRef.addValueEventListener(valueEventListener)
        } else {
            val intent = Intent(activity, SplashActivity::class.java)
            startActivity(intent)
            activity?.finish()
        }

















        ovunBtn.setOnClickListener(){
            if(ovunEnabled){
                val intent = Intent(activity, VipActivity::class.java)
                intent.putExtra("vip_id",0)
                startActivity(intent)
            }else{
                vipErrorMsg()
            }
        }

        htftBtn.setOnClickListener(){
            if(htftEnabled){
                val intent = Intent(activity, VipActivity::class.java)
                intent.putExtra("vip_id",1)
                startActivity(intent)
            }else{
                vipErrorMsg()
            }
        }

        oddsBtn.setOnClickListener(){
            if(oddsEnabled){
                val intent = Intent(activity, VipActivity::class.java)
                intent.putExtra("vip_id",2)
                startActivity(intent)
            }else{
                vipErrorMsg()
            }
        }

        platBtn.setOnClickListener(){
            if(platEnabled){
                val intent = Intent(activity, VipActivity::class.java)
                intent.putExtra("vip_id",3)
                startActivity(intent)
            }else{
                vipErrorMsg()
            }
        }



        swipeRefresh.setOnRefreshListener {
            getNewsData(1)
            fullyLoaded = false
        }

        getNewsData(1)

        return v

    }

    private fun getNewsData(page: Int){
        if(page == 1 && !loadingLy.isVisible){
            loadingLy.visibility = View.VISIBLE
        }

        pageId = page

        val url = "$serverUrl/$macLang/$page"

        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                activity?.runOnUiThread {
                    showErrorMsg()
                }
            }

            override fun onResponse(call: Call, response: Response) {
                activity?.runOnUiThread {
                    try {
                        val strResponse = response.body()!!.string()
                        val json = JSONObject(strResponse)

                        loadingLy.visibility = View.GONE

                        if(loadingMore.isVisible){
                            loadingMore.visibility = View.GONE
                        }

                        moreLoading = false

                        if (json.has("status")) {
                            val status = json.getString("status")
                            if(status == "ok"){
                                if(page == 1){
                                    macList1.clear()
                                }

                                val data = json.getJSONObject("data")
                                for (i in 0 until data.length()) {
                                    val item = data.getJSONObject(i.toString())
                                    macList1.add(NewsData(item.getString("id").toInt(), item.getString("newstext"), item.getString("flag") ))
                                }
                                setData()
                            }else if(status == "null_data"){
                                fullyLoaded = true
                                swipeRefresh.isRefreshing = false
                            }
                        }
                    } catch (jpe: JSONException) {
                        showErrorMsg()
                        Log.d("testRun", jpe.toString())
                    } catch (ioe: IOException) {
                        showErrorMsg()
                        Log.d("testRun", ioe.toString())
                    }
                }
            }
        })
    }

    private fun setData(){
        if(macList1.size > 0){
            adapter = activity?.let { RCAdapterNews(macList1, it, this) }
            rcview.adapter = adapter
        }
        if(loadingLy.isVisible){
            loadingLy.visibility = View.GONE
        }
        swipeRefresh.isRefreshing = false
    }

    override fun onClick(id: Int, price: Int, result: Int){
    }
    private fun showErrorMsg(){
        val builder = activity?.let { androidx.appcompat.app.AlertDialog.Builder(it) }
        builder?.setTitle(getString(R.string.error))
        builder?.setMessage(getString(R.string.errorGet))
            ?.setCancelable(false)
            ?.setPositiveButton(getString(R.string.retry)) { _, _ ->
                getNewsData(1)
            }
        val alert = builder?.create()
        alert?.show()
    }

    private fun vipErrorMsg(){
        val builder = activity?.let { androidx.appcompat.app.AlertDialog.Builder(it) }
        builder?.setTitle(getString(R.string.vipSection))
        builder?.setMessage(getString(R.string.vipSectionDes))
            ?.setCancelable(true)
            ?.setPositiveButton(getString(R.string.ok)) { _, _ ->

            }
        val alert = builder?.create()
        alert?.show()
    }

    fun getDate(timestamp: Long): Calendar {
        val calendar = Calendar.getInstance(Locale.ENGLISH)
        calendar.timeInMillis = timestamp * 1000L
        return calendar
    }

}

