package com.roid.bettingtips.pages

import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ProgressBar
import android.widget.RelativeLayout
import androidx.core.view.isVisible
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.google.firebase.auth.FirebaseAuth
import com.tapadoo.alerter.Alerter
import com.roid.bettingtips.ItemClickListener
import com.roid.bettingtips.R
import com.roid.bettingtips.adapters.RCAdapter
import com.roid.bettingtips.data.MacData
import okhttp3.*
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException
import java.util.*

class PaidFragment : Fragment(), ItemClickListener {
    private lateinit var swipeRefresh: SwipeRefreshLayout
    private lateinit var rcview: RecyclerView
    private lateinit var loadingMore: ProgressBar
    private lateinit var loadingLy: RelativeLayout
    private var adapter: RecyclerView.Adapter<RCAdapter.ViewHolder>? = null
    private var layoutManager: RecyclerView.LayoutManager? = null
    private val client = OkHttpClient()
    private var serverUrl: String = "https://api.roidbetting.online/getPaidData"
    private var purchaseServerUrl: String = "https://api.roidbetting.online/buy"
    private var macLang = "tr"
    private var utoken: String = "null"
    private var macList: MutableList<MacData> = mutableListOf()
    private var moreLoading = false
    private var fullyLoaded = false
    private var pageId = 1

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val v = inflater.inflate(R.layout.fragment_paid, container, false)

        swipeRefresh = v.findViewById(R.id.swiperefreshpaid)
        loadingMore = v.findViewById(R.id.loadingMorePaid)
        loadingLy = v.findViewById(R.id.loadingLayout)
        rcview = v.findViewById(R.id.RCviewPaid)
        layoutManager = LinearLayoutManager(activity)
        rcview.layoutManager = layoutManager

        macLang = if(Locale.getDefault().language == "tr"){ "tr" }else{ "en" }

        FirebaseAuth.getInstance().currentUser?.getIdToken(true)?.addOnSuccessListener {
            it.token?.let { it1 -> utoken = it1 }
            getData(1)
        }

        rcview.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                if (dy > 0) {
                    val visibleItemCount = layoutManager?.childCount
                    val totalItemCount = layoutManager?.itemCount
                    val pastVisiblesItems = (rcview.layoutManager as LinearLayoutManager?)?.findFirstVisibleItemPosition()

                    if(!moreLoading && !fullyLoaded){
                        if ((visibleItemCount!! + pastVisiblesItems!!) >= totalItemCount!!) {
                            loadingMore.visibility = View.VISIBLE
                            pageId += 1
                            getData(pageId)
                            moreLoading = true
                        }
                    }
                }
            }
        })

        swipeRefresh.setOnRefreshListener {
            refresh()
        }

        return v
    }

    private fun getData(page: Int){
        if(page == 1 && !loadingLy.isVisible){
            loadingLy.visibility = View.VISIBLE
        }

        pageId = page

        val url = "$serverUrl/$utoken/$macLang/$page"

        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                activity?.runOnUiThread {
                    showErrorMsg()
                }
            }

            override fun onResponse(call: Call, response: Response) {
                activity?.runOnUiThread {
                    try {

                        val strResponse = response.body()!!.string()
                        val json = JSONObject(strResponse)

                        loadingLy.visibility = View.GONE

                        if(loadingMore.isVisible){
                            loadingMore.visibility = View.GONE
                        }

                        moreLoading = false

                        if (json.has("status")) {
                            val status = json.getString("status")
                            if(status == "ok"){
                                if(page == 1){
                                    macList.clear()
                                }

                                Log.d("testRub", "wtf")
                                val data = json.getJSONObject("data")
                                for (i in 0 until data.length()) {
                                    val item = data.getJSONObject(i.toString())
                                    macList.add(MacData(item.getString("id").toInt(), item.getString("price").toInt(), item.getString("userBought").toInt(), item.getString("leagueName"), item.getString("teamOne"), item.getString("teamTwo"), item.getString("date"), item.getString("result").toInt(), item.getString("teamOneScore"), item.getString("teamTwoScore"), item.getString("info"), item.getString("ratio") ))
                                }
                                setData()
                            }else if(status == "null_data"){
                                fullyLoaded = true
                                swipeRefresh.isRefreshing = false
                            }
                        }
                    } catch (jpe: JSONException) {
                        showErrorMsg()
                        Log.d("testRun", jpe.toString())
                    } catch (ioe: IOException) {
                        showErrorMsg()
                        Log.d("testRun", ioe.toString())
                    }
                }
            }
        })
    }

    private fun setData(){
        if(macList.size > 0){
            adapter = activity?.let { RCAdapter(macList, it,this) }
            rcview.adapter = adapter

        }
        if(loadingLy.isVisible){
            loadingLy.visibility = View.GONE
        }
        swipeRefresh.isRefreshing = false
    }

    override fun onClick(id: Int, price: Int, result: Int){
        if(result == 0){
            askToBuy(id,price)
        }else{
            showResultMsg()
        }
    }


    private fun showErrorMsg(){
        val builder = activity?.let { androidx.appcompat.app.AlertDialog.Builder(it) }
        builder?.setTitle(getString(R.string.error))
        builder?.setMessage(getString(R.string.errorGet))
            ?.setCancelable(false)
            ?.setPositiveButton(getString(R.string.retry)) { _, _ ->
                getData(1)
            }
        val alert = builder?.create()
        alert?.show()
    }

    private fun showResultMsg(){
        val builder = activity?.let { androidx.appcompat.app.AlertDialog.Builder(it) }
        builder?.setTitle(getString(R.string.error))
        builder?.setMessage(getString(R.string.gameFinished))
            ?.setCancelable(true)
            ?.setPositiveButton(getString(R.string.ok)) { _, _ ->
            }
        val alert = builder?.create()
        alert?.show()
    }

    private fun askToBuy(id: Int, price: Int){
        val builder = activity?.let { androidx.appcompat.app.AlertDialog.Builder(it) }
        builder?.setTitle(getString(R.string.purchase))
        builder?.setMessage(getString(R.string.purchaseDes, price))
            ?.setCancelable(true)
            ?.setPositiveButton(getString(R.string.confirm)) { _, _ ->
                buy(id, utoken)
            }
            ?.setNegativeButton(getString(R.string.cancel)) { _, _ ->

            }
        val alert = builder?.create()
        alert?.show()
    }

    private fun buy(id: Int, token: String){
        if(!loadingLy.isVisible){
            loadingLy.visibility = View.VISIBLE
        }

        val url = "$purchaseServerUrl/$token/$id"
        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                activity?.runOnUiThread {
                    //showErrorMsg()
                }
            }

            override fun onResponse(call: Call, response: Response) {
                activity?.runOnUiThread {
                    try {
                        val strResponse = response.body()!!.string()
                        val json = JSONObject(strResponse)

                        if(loadingLy.isVisible){
                            loadingLy.visibility = View.GONE
                        }

                        if (json.has("status")) {
                            val status = json.getString("status")

                            when(status){
                                "ok" -> {
                                    activity?.let {
                                        Alerter.create(it)
                                            .setTitle(getString(R.string.jobSuccessful))
                                            .setText(getString(R.string.purchaseSuccessful))
                                            .setIcon(R.drawable.ic_baseline_check_circle_outline)
                                            .setBackgroundColorRes(R.color.success_color)
                                            .show()
                                    }
                                    refresh()

                                }
                                "insufficient_credit" -> {
                                    activity?.let {
                                        Alerter.create(it)
                                            .setTitle(getString(R.string.error))
                                            .setText(getString(R.string.insufficientCredit))
                                            .setIcon(R.drawable.ic_error)
                                            .setBackgroundColorRes(R.color.error_color)
                                            .show()
                                    }
                                }
                            }
                        }
                    } catch (jpe: JSONException) {
                        Log.d("testRun", jpe.toString())
                    } catch (ioe: IOException) {
                        Log.d("testRun", ioe.toString())
                    }
                }
            }
        })
    }

    private fun refresh(){
        getData(1)
        fullyLoaded = false
    }

}