package com.roid.bettingtips.adapters

import android.app.Activity
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.recyclerview.widget.RecyclerView
import com.roid.bettingtips.ItemClickListener
import com.roid.bettingtips.data.MacData
import com.roid.bettingtips.R

class RCAdapter (var data: MutableList<MacData>, var activity: Activity, val itemClickListener: ItemClickListener) : RecyclerView.Adapter<RCAdapter.ViewHolder>() {

    inner class ViewHolder(itemView: View) : RecyclerView.ViewHolder(itemView) {
        var leagueName: TextView = itemView.findViewById(R.id.leagueName)
        var teamOne: TextView = itemView.findViewById(R.id.teamOne)
        var teamTwo: TextView = itemView.findViewById(R.id.teamTwo)
        var infoText: TextView = itemView.findViewById(R.id.infoText)
        var dateText: TextView = itemView.findViewById(R.id.date)
        var teamOneScore: TextView = itemView.findViewById(R.id.teamOneScore)
        var teamTwoScore: TextView = itemView.findViewById(R.id.teamTwoScore)
        var priceText: TextView = itemView.findViewById(R.id.priceText)
        var ratioText: TextView = itemView.findViewById(R.id.ratioText)
        var resultImage: ImageView = itemView.findViewById(R.id.result_img)
        var buyLy: RelativeLayout = itemView.findViewById(R.id.buyLy)
        var scoreLy: RelativeLayout = itemView.findViewById(R.id.scoreLy)

        init{
            buyLy.setOnClickListener{itemClickListener.onClick(data[adapterPosition].id, data[adapterPosition].price, data[adapterPosition].result)}
        }
    }

    override fun onCreateViewHolder(viewGroup: ViewGroup, i: Int): ViewHolder {
        val v = LayoutInflater.from(viewGroup.context).inflate(R.layout.item_layout, viewGroup, false)
        return ViewHolder(v)
    }

    override fun onBindViewHolder(v: ViewHolder, i: Int) {
        v.leagueName.text = data[i].leagueName
        v.teamOne.text = data[i].teamOne
        v.teamTwo.text = data[i].teamTwo
        v.dateText.text = data[i].date

        v.dateText.text = data[i].date


        if(data[i].price > 0){
            if(data[i].userBought == 0){
                v.buyLy.visibility = View.VISIBLE
                v.scoreLy.visibility = View.GONE
                v.priceText.text = data[i].price.toString()
                v.teamOneScore.text =  "-"
                v.teamTwoScore.text =  "-"
                v.ratioText.text = "Locked"
                v.infoText.text = "Locked"
            }else{
                v.scoreLy.visibility = View.VISIBLE
                v.buyLy.visibility = View.GONE
                v.teamOneScore.text =  data[i].teamOneScore
                v.teamTwoScore.text =  data[i].teamTwoScore
                v.ratioText.text = data[i].ratio
                v.infoText.text = data[i].info
            }
        }else{
            v.infoText.text = data[i].info
            v.teamOneScore.text =  data[i].teamOneScore
            v.teamTwoScore.text =  data[i].teamTwoScore
            v.ratioText.text = data[i].ratio
        }

        when(data[i].result){
            0 -> v.resultImage.setImageResource(R.drawable.ic_question)
            1 -> v.resultImage.setImageResource(R.drawable.ic_tick)
            2 -> v.resultImage.setImageResource(R.drawable.ic_wrong)
        }

    }

    override fun getItemCount(): Int {
        return data.size
    }


}