package com.roid.bettingtips

import androidx.appcompat.app.AppCompatActivity
import android.os.Bundle
import android.util.Log
import android.view.View
import android.widget.ProgressBar
import android.widget.RelativeLayout
import android.widget.TextView
import androidx.appcompat.widget.Toolbar
import androidx.core.view.isVisible
import androidx.recyclerview.widget.LinearLayoutManager
import androidx.recyclerview.widget.RecyclerView
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout
import com.google.firebase.auth.FirebaseAuth
import com.roid.bettingtips.adapters.RCAdapter
import com.roid.bettingtips.data.MacData
import okhttp3.*
import org.json.JSONException
import org.json.JSONObject
import java.io.IOException
import java.util.*

class VipActivity : AppCompatActivity(), ItemClickListener  {
    private lateinit var swipeRefresh: SwipeRefreshLayout
    private lateinit var rcview: RecyclerView
    private lateinit var loadingLy: RelativeLayout
    private lateinit var loadingMore: ProgressBar
    private var adapter: RecyclerView.Adapter<RCAdapter.ViewHolder>? = null
    private var layoutManager: RecyclerView.LayoutManager? = null
    private val client = OkHttpClient()
    private var serverUrl: String = "https://api.roidbetting.online/getOvunData"
    private var macLang = "tr"
    private var utoken: String = "null"
    private var macList: MutableList<MacData> = mutableListOf()
    private var moreLoading = false
    private var fullyLoaded = false
    private var pageId = 1

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_vip)

        val pgTitle: TextView = findViewById(R.id.pageTitle)
        val toolbar = findViewById<Toolbar>(R.id.toolbar)
        setSupportActionBar(toolbar)

        macLang = if(Locale.getDefault().language == "tr"){ "tr" }else{ "en" }
        val vip_id = intent.getIntExtra("vip_id", 0)

        when(vip_id){
            0-> {
                serverUrl = "https://api.roidbetting.online/getOvunData"
                pgTitle.text = getString(R.string.ovun)
                chekUid()
            }

            1->{
                serverUrl = "https://api.roidbetting.online/getHtftData"
                pgTitle.text = getString(R.string.htft)
                chekUid()
            }

            2->{
                serverUrl = "https://api.roidbetting.online/getOddsData"
                pgTitle.text = getString(R.string.odds)
                chekUid()
            }

            3->{
                serverUrl = "https://api.roidbetting.online/getPlatData"
                pgTitle.text = getString(R.string.plat)
                chekUid()
            }
        }

        supportActionBar!!.setDisplayHomeAsUpEnabled(true)
        supportActionBar!!.setDisplayShowTitleEnabled(false)

        loadingLy = findViewById(R.id.loadingLayout)
        swipeRefresh = findViewById(R.id.swiperefresh)
        loadingMore = findViewById(R.id.loadingMore)
        rcview = findViewById(R.id.RCview)
        layoutManager = LinearLayoutManager(this)
        rcview.layoutManager = layoutManager


        rcview.addOnScrollListener(object : RecyclerView.OnScrollListener() {
            override fun onScrolled(recyclerView: RecyclerView, dx: Int, dy: Int) {
                if (dy > 0) {
                    val visibleItemCount = layoutManager?.childCount
                    val totalItemCount = layoutManager?.itemCount
                    val pastVisiblesItems = (rcview.layoutManager as LinearLayoutManager?)?.findFirstVisibleItemPosition()

                    if(!moreLoading && !fullyLoaded){
                        if ((visibleItemCount!! + pastVisiblesItems!!) >= totalItemCount!!) {
                            loadingMore.visibility = View.VISIBLE
                            pageId += 1
                            getData(pageId)
                            moreLoading = true
                        }
                    }
                }
            }
        })

        swipeRefresh.setOnRefreshListener {
            getData(1)
            fullyLoaded = false
        }

        toolbar.setNavigationOnClickListener {
            finish()
        }


    }

    private fun chekUid(){
        FirebaseAuth.getInstance().currentUser?.getIdToken(true)?.addOnSuccessListener {
            it.token?.let { it1 -> utoken = it1 }
            getData(1)
        }
    }

    private fun getData(page: Int){
        if(page == 1 && !loadingLy.isVisible){
            loadingLy.visibility = View.VISIBLE
        }

        pageId = page

        val url = "$serverUrl/$utoken/$macLang/$page"
        val request = Request.Builder()
            .url(url)
            .build()

        client.newCall(request).enqueue(object : Callback {
            override fun onFailure(call: Call, e: IOException) {
                runOnUiThread {
                    showErrorMsg()
                }
            }

            override fun onResponse(call: Call, response: Response) {
                runOnUiThread {
                    try {
                        val strResponse = response.body()!!.string()
                        val json = JSONObject(strResponse)

                        loadingLy.visibility = View.GONE

                        if(loadingMore.isVisible){
                            loadingMore.visibility = View.GONE
                        }

                        moreLoading = false

                        if (json.has("status")) {
                            val status = json.getString("status")
                            if(status == "ok"){
                                if(page == 1){
                                    macList.clear()
                                }

                                val data = json.getJSONObject("data")
                                for (i in 0 until data.length()) {
                                    val item = data.getJSONObject(i.toString())
                                    macList.add(MacData(item.getString("id").toInt(), item.getString("price").toInt(), item.getString("userBought").toInt(), item.getString("leagueName"), item.getString("teamOne"), item.getString("teamTwo"), item.getString("date"), item.getString("result").toInt(), item.getString("teamOneScore"), item.getString("teamTwoScore"), item.getString("info"), item.getString("ratio") ))
                                }
                                setData()
                            }else if(status == "null_data"){
                                fullyLoaded = true
                                swipeRefresh.isRefreshing = false
                            }else if(status == "not_vip"){
                                vipErrorMsg()
                            }
                        }
                    } catch (jpe: JSONException) {
                        showErrorMsg()
                        Log.d("testRun", jpe.toString())
                    } catch (ioe: IOException) {
                        showErrorMsg()
                        Log.d("testRun", ioe.toString())
                    }
                }
            }
        })
    }

    private fun setData(){
        if(macList.size > 0){
            adapter = RCAdapter(macList, this, this)
            rcview.adapter = adapter
        }
        swipeRefresh.isRefreshing = false
    }

    override fun onClick(id: Int, price: Int, result: Int){
    }


    private fun showErrorMsg(){
        val builder = androidx.appcompat.app.AlertDialog.Builder(this)
        builder.setTitle(getString(R.string.error))
        builder.setMessage(getString(R.string.errorGet))
            .setCancelable(false)
            .setPositiveButton(getString(R.string.retry)) { _, _ ->
                getData(1)
            }
        val alert = builder.create()
        alert.show()
    }

    private fun vipErrorMsg(){
        val builder = androidx.appcompat.app.AlertDialog.Builder(this)
        builder.setTitle(getString(R.string.vipSection))
        builder.setMessage(getString(R.string.vipSectionDes))
            .setCancelable(false)
            .setNegativeButton(getString(R.string.cancel)) { _, _ ->
                finish()
            }
        val alert = builder.create()
        alert.show()
    }
}