package com.roid.bettingtips

import android.graphics.Color
import android.os.Bundle
import android.util.Log
import androidx.fragment.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.TextView
import com.google.firebase.auth.ktx.auth
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.google.firebase.database.DatabaseReference
import com.google.firebase.database.ValueEventListener
import com.google.firebase.database.ktx.database
import com.google.firebase.ktx.Firebase
import com.roid.bettingtips.pages.*
import java.util.*

class HomeFragment : Fragment() {

    private lateinit var database: DatabaseReference
    private lateinit var userCoin: TextView
    private lateinit var freeBtn: Button
    private lateinit var paidBtn: Button
    private lateinit var vipBtn: Button
    private lateinit var wonBtn: Button
    private lateinit var shopBtn: Button

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        val v = inflater.inflate(R.layout.fragment_home, container, false)
        changeFragment(FreeFragment())

        database = Firebase.database.reference
        getCredit()

        freeBtn = v.findViewById(R.id.freeBtn)
        paidBtn = v.findViewById(R.id.paidBtn)
        vipBtn = v.findViewById(R.id.vipBtn)
        wonBtn = v.findViewById(R.id.wonBtn)
        shopBtn = v.findViewById(R.id.shopBtn)
        userCoin = v.findViewById(R.id.userCoin)

        freeBtn.setOnClickListener(){
            changeFragment(FreeFragment())
            freeBtn.isEnabled = false
            paidBtn.isEnabled = true
            vipBtn.isEnabled = true
            wonBtn.isEnabled = true
            shopBtn.isEnabled = true
            freeBtn.setTextColor(Color.parseColor("#FED543"))
            paidBtn.setTextColor(Color.parseColor("#922425"))
            vipBtn.setTextColor(Color.parseColor("#922425"))
            wonBtn.setTextColor(Color.parseColor("#922425"))
            shopBtn.setTextColor(Color.parseColor("#922425"))
        }

        paidBtn.setOnClickListener(){
            changeFragment(PaidFragment())
            freeBtn.isEnabled = true
            paidBtn.isEnabled = false
            vipBtn.isEnabled = true
            wonBtn.isEnabled = true
            shopBtn.isEnabled = true
            freeBtn.setTextColor(Color.parseColor("#922425"))
            paidBtn.setTextColor(Color.parseColor("#FED543"))
            vipBtn.setTextColor(Color.parseColor("#922425"))
            wonBtn.setTextColor(Color.parseColor("#922425"))
            shopBtn.setTextColor(Color.parseColor("#922425"))
        }

        vipBtn.setOnClickListener(){
            changeFragment(VipFragment())
            freeBtn.isEnabled = true
            paidBtn.isEnabled = true
            vipBtn.isEnabled = false
            wonBtn.isEnabled = true
            shopBtn.isEnabled = true
            freeBtn.setTextColor(Color.parseColor("#922425"))
            paidBtn.setTextColor(Color.parseColor("#922425"))
            vipBtn.setTextColor(Color.parseColor("#FED543"))
            wonBtn.setTextColor(Color.parseColor("#922425"))
            shopBtn.setTextColor(Color.parseColor("#922425"))
        }

        wonBtn.setOnClickListener(){
            changeFragment(WonFragment())
            freeBtn.isEnabled = true
            paidBtn.isEnabled = true
            vipBtn.isEnabled = true
            wonBtn.isEnabled = false
            shopBtn.isEnabled = true
            freeBtn.setTextColor(Color.parseColor("#922425"))
            paidBtn.setTextColor(Color.parseColor("#922425"))
            vipBtn.setTextColor(Color.parseColor("#922425"))
            wonBtn.setTextColor(Color.parseColor("#FED543"))
            shopBtn.setTextColor(Color.parseColor("#922425"))
        }

        shopBtn.setOnClickListener(){
            changeFragment(ShopFragment())
            freeBtn.isEnabled = true
            paidBtn.isEnabled = true
            vipBtn.isEnabled = true
            wonBtn.isEnabled = true
            shopBtn.isEnabled = false
            freeBtn.setTextColor(Color.parseColor("#922425"))
            paidBtn.setTextColor(Color.parseColor("#922425"))
            vipBtn.setTextColor(Color.parseColor("#922425"))
            wonBtn.setTextColor(Color.parseColor("#922425"))
            shopBtn.setTextColor(Color.parseColor("#FED543"))
        }

        return v
    }

    private fun changeFragment(fragment: Fragment) {
        val fragmentTransaction = activity?.supportFragmentManager?.beginTransaction()
        fragmentTransaction?.replace(R.id.fragmentLayout, fragment)
        fragmentTransaction?.commit()
    }

    private fun getCredit(){
        val user = Firebase.auth.currentUser
        if (user != null) {
            //loadAd(user.uid)
            val ordersRef = database.child("users").child(user.uid)
            val valueEventListener = object : ValueEventListener {
                override fun onDataChange(dataSnapshot: DataSnapshot) {
                    userCoin.text = dataSnapshot.child("credit").value.toString()
                }

                override fun onCancelled(databaseError: DatabaseError) {
                    Log.d("Data", databaseError.message)
                }
            }
            ordersRef.addValueEventListener(valueEventListener)
        }
    }

    fun gotoShop(){
        changeFragment(ShopFragment())
        freeBtn.isEnabled = true
        paidBtn.isEnabled = true
        vipBtn.isEnabled = true
        wonBtn.isEnabled = true
        shopBtn.isEnabled = false
        freeBtn.setTextColor(Color.parseColor("#922425"))
        paidBtn.setTextColor(Color.parseColor("#922425"))
        vipBtn.setTextColor(Color.parseColor("#922425"))
        wonBtn.setTextColor(Color.parseColor("#922425"))
        shopBtn.setTextColor(Color.parseColor("#FED543"))
    }

}